/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.guidebook.button;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideChapter;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.gui.GuiGuide;
import net.silentchaos512.lib.guidebook.gui.GuiPage;
import net.silentchaos512.lib.guidebook.misc.GuideBookUtils;
import net.silentchaos512.lib.util.AssetUtil;

@SideOnly(value=Side.CLIENT)
public class BookmarkButton
extends GuiButton {
    private final GuiGuide booklet;
    protected GuideBook book;
    private IGuidePage assignedPage;

    public BookmarkButton(int id, int x, int y, GuiGuide booklet) {
        super(id, x, y, 16, 16, "");
        this.booklet = booklet;
        this.book = booklet.book;
    }

    public void onPressed() {
        if (this.assignedPage != null) {
            if (GuiScreen.func_146272_n()) {
                this.assignedPage = null;
            } else if (!(this.booklet instanceof GuiPage) || ((GuiPage)this.booklet).pages[0] != this.assignedPage) {
                GuiPage gui = GuideBookUtils.createPageGui(this.book, this.booklet.previousScreen, this.booklet, this.assignedPage);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
            }
        } else if (this.booklet instanceof GuiPage) {
            this.assignedPage = ((GuiPage)this.booklet).pages[0];
        }
    }

    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float par4) {
        if (this.field_146125_m) {
            ItemStack display;
            minecraft.func_110434_K().func_110577_a(this.book.getResourceGadgets());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            if (k == 0) {
                k = 1;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)771);
            int renderHeight = 25;
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 224 + (this.assignedPage == null ? 0 : 16), 14 - renderHeight + k * renderHeight, this.field_146120_f, renderHeight);
            this.func_146119_b(minecraft, mouseX, mouseY);
            if (this.assignedPage != null && !(display = this.assignedPage.getChapter().getDisplayItemStack()).func_190926_b()) {
                GlStateManager.func_179094_E();
                AssetUtil.renderStackToGui(display, this.field_146128_h + 2, this.field_146129_i + 1, 0.725f);
                GlStateManager.func_179121_F();
            }
        }
    }

    public void drawHover(int mouseX, int mouseY) {
        if (this.func_146115_a()) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.assignedPage != null) {
                IGuideChapter chapter = this.assignedPage.getChapter();
                list.add(TextFormatting.GOLD + chapter.getLocalizedName() + ", Page " + (chapter.getPageIndex(this.assignedPage) + 1));
                list.add(this.book.i18n.translate("guide", "bookmarkButton.bookmark.openDesc", new Object[0]));
                list.add(TextFormatting.ITALIC + this.book.i18n.translate("guide", "bookmarkButton.bookmark.removeDesc", new Object[0]));
            } else {
                list.add(TextFormatting.GOLD + this.book.i18n.translate("guide", "bookmarkButton.noBookmark.name", new Object[0]));
                if (this.booklet instanceof GuiPage) {
                    list.add(this.book.i18n.translate("guide", "bookmarkButton.noBookmark.pageDesc", new Object[0]));
                } else {
                    list.add(this.book.i18n.translate("guide", "bookmarkButton.noBookmark.notPageDesc", new Object[0]));
                }
            }
            Minecraft mc = Minecraft.func_71410_x();
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }
}

